/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.resource.crate;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.resource.crate.AbstractCountFunction;
import dev.toma.gunsrpg.resource.crate.CountFunctionRegistry;
import dev.toma.gunsrpg.resource.crate.ICountFunction;
import dev.toma.gunsrpg.resource.crate.ICountFunctionAdapter;
import dev.toma.gunsrpg.resource.crate.LootManager;
import dev.toma.gunsrpg.resource.util.functions.IFunction;
import java.util.Random;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;

public class RandomCount
extends AbstractCountFunction {
    private static final Random RANDOM = new Random();
    private final int lowerBound;
    private final int upperBound;

    private RandomCount(int lowerBound, int upperBound) {
        super(CountFunctionRegistry.RNG);
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public static ICountFunction fromInterval(int lower, int upper) {
        return new RandomCount(lower, upper);
    }

    @Override
    public int getCount() {
        return this.lowerBound + RANDOM.nextInt(this.upperBound - this.lowerBound + 1);
    }

    public static class Adapter
    implements ICountFunctionAdapter<RandomCount> {
        @Override
        public ICountFunction deserialize(JsonObject data, IFunction range) {
            int upper;
            int lower = JSONUtils.func_151203_m((JsonObject)data, (String)"min");
            if (lower == (upper = JSONUtils.func_151203_m((JsonObject)data, (String)"max"))) {
                GunsRPG.log.warn(LootManager.MARKER, "Using 'rng' function with constant range, maybe you wanted to use 'const' function instead");
            }
            if (lower > upper) {
                throw new JsonSyntaxException("Lower bound cannot be bigger than upper bound!");
            }
            this.validateInRange(lower, range);
            this.validateInRange(upper, range);
            return RandomCount.fromInterval(lower, upper);
        }

        @Override
        public void encode(RandomCount function, PacketBuffer buffer) {
            buffer.writeInt(function.lowerBound);
            buffer.writeInt(function.upperBound);
        }

        @Override
        public RandomCount decode(PacketBuffer buffer) {
            return new RandomCount(buffer.readInt(), buffer.readInt());
        }

        private void validateInRange(int value, IFunction range) {
            if (!range.canApplyFor(value)) {
                throw new JsonSyntaxException("Value is out of bounds");
            }
        }
    }
}

